class BookShelfReference extends SoftReference
 {
     String subject;
     static ReferenceQueue collectedQueue = new ReferenceQueue();
 
     public BookShelfReference (BookShelf shelf)
     {
         super(shelf, collectedQueue);
         this.subject = shelf.subject;
     }
 }
 
 class GarbageMonitor extends Thread
 {
     ReferenceQueue queue;
 
     public GarbageMonitor (ReferenceQueue queue)
     {
         this.queue = queue;
     }
 
     public void run ()
     {
         while (true)
         {
             try
             {
                 BookShelfReference shelfRef =
                     (BookShelfReference) queue.remove(5000);
                 System.out.println("Monitor: Shelf subject '" +
                      shelfRef.subject + "' was collected.");
             }
             catch (Exception e)
             {   break;  }
         }
     }
 }
